<?php
// Application configuration
session_start();

// Base URL configuration
define('BASE_URL', 'http://localhost/tv/');
define('UPLOAD_PATH', 'uploads/');
define('M3U_UPLOAD_PATH', 'uploads/m3u/');
define('LOGO_UPLOAD_PATH', 'uploads/logos/');

// Create upload directories if they don't exist
if (!file_exists(UPLOAD_PATH)) {
    mkdir(UPLOAD_PATH, 0777, true);
}
if (!file_exists(M3U_UPLOAD_PATH)) {
    mkdir(M3U_UPLOAD_PATH, 0777, true);
}
if (!file_exists(LOGO_UPLOAD_PATH)) {
    mkdir(LOGO_UPLOAD_PATH, 0777, true);
}

// Include database configuration
require_once __DIR__ . '/database.php';

// Helper functions
function redirect($url) {
    header("Location: " . BASE_URL . $url);
    exit();
}

function isLoggedIn() {
    return isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true;
}

function requireLogin() {
    if (!isLoggedIn()) {
        redirect('admin/login.php');
    }
}

function sanitizeInput($input) {
    return htmlspecialchars(strip_tags(trim($input)));
}

function uploadFile($file, $uploadPath, $allowedTypes = []) {
    if (!isset($file['error']) || is_array($file['error'])) {
        return ['success' => false, 'message' => 'Invalid file upload'];
    }

    if ($file['error'] !== UPLOAD_ERR_OK) {
        return ['success' => false, 'message' => 'File upload error'];
    }

    $fileName = basename($file['name']);
    $fileType = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
    
    if (!empty($allowedTypes) && !in_array($fileType, $allowedTypes)) {
        return ['success' => false, 'message' => 'Invalid file type'];
    }

    $newFileName = uniqid() . '_' . $fileName;
    $targetPath = $uploadPath . $newFileName;

    if (move_uploaded_file($file['tmp_name'], $targetPath)) {
        return ['success' => true, 'file_path' => $targetPath, 'file_name' => $newFileName];
    } else {
        return ['success' => false, 'message' => 'Failed to move uploaded file'];
    }
}
?>
