<?php
// Script to create admin user with proper password hash
require_once 'config/config.php';

try {
    $pdo = getDBConnection();
    
    // Check if admin user already exists
    $stmt = $pdo->prepare("SELECT id FROM admin_users WHERE username = ?");
    $stmt->execute(['admin']);
    $existingUser = $stmt->fetch();
    
    if ($existingUser) {
        // Update existing admin user with correct password
        $hashedPassword = password_hash('admin123', PASSWORD_DEFAULT);
        $stmt = $pdo->prepare("UPDATE admin_users SET password = ? WHERE username = ?");
        $stmt->execute([$hashedPassword, 'admin']);
        echo "✅ Admin user password updated successfully!<br>";
    } else {
        // Create new admin user
        $hashedPassword = password_hash('admin123', PASSWORD_DEFAULT);
        $stmt = $pdo->prepare("INSERT INTO admin_users (username, password, email) VALUES (?, ?, ?)");
        $stmt->execute(['admin', $hashedPassword, 'admin@example.com']);
        echo "✅ Admin user created successfully!<br>";
    }
    
    echo "<br><strong>Admin Credentials:</strong><br>";
    echo "Username: admin<br>";
    echo "Password: admin123<br><br>";
    echo "<a href='admin/login.php'>Go to Admin Login</a> | <a href='index.php'>Go to Website</a>";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage();
}
?>
