<?php
// Script to add is_pinned column to tv_channels table
require_once 'config/config.php';

try {
    $pdo = getDBConnection();
    
    // Check if column already exists
    $stmt = $pdo->query("SHOW COLUMNS FROM tv_channels LIKE 'is_pinned'");
    $columnExists = $stmt->fetch();
    
    if (!$columnExists) {
        // Add the column
        $pdo->exec("ALTER TABLE tv_channels ADD COLUMN is_pinned BOOLEAN DEFAULT FALSE");
        echo "✅ Successfully added 'is_pinned' column to tv_channels table.<br>";
    } else {
        echo "✅ Column 'is_pinned' already exists in tv_channels table.<br>";
    }
    
    echo "<br><strong>Pin Feature Setup Complete!</strong><br>";
    echo "You can now pin channels from the admin panel.<br><br>";
    echo "<a href='admin/channels.php'>Go to Channel Management</a> | <a href='index.php'>View Website</a>";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage();
}
?>
